/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.web.servlet;

import com.axelor.app.AppSettings;
import com.axelor.meta.loader.ModuleManager;
import com.axelor.quartz.JobRunner;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InitServlet
extends HttpServlet {
    private static final long serialVersionUID = -2493577642638670615L;
    private static final Logger LOG = LoggerFactory.getLogger(InitServlet.class);
    @Inject
    private ModuleManager moduleManager;
    @Inject
    private JobRunner jobRunner;

    public void init() throws ServletException {
        LOG.info("Initializing...");
        try {
            this.moduleManager.initialize(false, AppSettings.get().getBoolean("data.import.demo-data", true));
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        try {
            if (this.jobRunner.isEnabled()) {
                this.jobRunner.start();
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        super.init();
    }

    public void destroy() {
        try {
            this.jobRunner.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.destroy();
    }
}

