/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.web.servlet;

import com.axelor.app.internal.AppFilter;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.zip.GZIPOutputStream;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
public class I18nServlet
extends HttpServlet {
    private static final long serialVersionUID = -6879530734799286544L;
    private static final String CONTENT_ENCODING = "Content-Encoding";
    private static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static final String GZIP_ENCODING = "gzip";
    private static final String CONTENT_TYPE = "application/javascript; charset=utf8";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ResourceBundle bundle;
        Locale locale = AppFilter.getLocale();
        if (locale == null) {
            locale = req.getLocale();
        }
        if ((bundle = I18n.getBundle((Locale)locale)) == null) {
            resp.setStatus(404);
            return;
        }
        resp.setContentType(CONTENT_TYPE);
        Object out = resp.getOutputStream();
        if (req.getHeader(ACCEPT_ENCODING) != null && req.getHeader(ACCEPT_ENCODING).toLowerCase().indexOf(GZIP_ENCODING) > -1) {
            resp.setHeader(CONTENT_ENCODING, GZIP_ENCODING);
            out = new GZIPOutputStream((OutputStream)out);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("(function() {");
        builder.append("this._t={};_t.bundle=");
        Enumeration<String> keys = bundle.getKeys();
        HashMap<String, String> messages = new HashMap<String, String>();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            messages.put(key, bundle.getString(key));
        }
        try {
            ObjectMapper mapper = (ObjectMapper)Beans.get(ObjectMapper.class);
            builder.append(mapper.writeValueAsString(messages)).append(";");
            builder.append("}(this));");
        }
        catch (Exception e) {
            resp.sendError(500);
            return;
        }
        ((OutputStream)out).write(builder.toString().getBytes());
        ((OutputStream)out).close();
    }
}

