/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.web.servlet;

import com.axelor.app.AppSettings;
import com.axelor.common.StringUtils;
import java.io.IOException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CorsFilter
implements Filter {
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String DEFAULT_CORS_ALLOW_ORIGIN = "*";
    private static final String DEFAULT_CORS_ALLOW_CREDENTIALS = "true";
    private static final String DEFAULT_CORS_ALLOW_METHODS = "GET,PUT,POST,DELETE,HEAD,OPTIONS";
    private static final String DEFAULT_CORS_ALLOW_HEADERS = "Origin,Accept,X-Requested-With,Content-Type,Access-Control-Request-Method,Access-Control-Request-Headers";
    private static final String DEFAULT_EXPOSE_HEADERS = "";
    private static final String DEFAULT_CORS_MAX_AGE = "1728000";
    private static Pattern corsOriginPattern;
    private static String corsAllowOrigin;
    private static String corsAllowCredentials;
    private static String corsAllowMethods;
    private static String corsAllowHeaders;
    private static String corsExposeHeaders;
    private static String corsMaxAge;
    private Logger log = LoggerFactory.getLogger(CorsFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        AppSettings settings = AppSettings.get();
        corsAllowOrigin = settings.get("cors.allow.origin");
        corsAllowCredentials = settings.get("cors.allow.credentials", DEFAULT_CORS_ALLOW_CREDENTIALS);
        corsAllowMethods = settings.get("cors.allow.methods", DEFAULT_CORS_ALLOW_METHODS);
        corsAllowHeaders = settings.get("cors.allow.headers", DEFAULT_CORS_ALLOW_HEADERS);
        corsExposeHeaders = settings.get("cors.expose.headers", DEFAULT_EXPOSE_HEADERS);
        corsMaxAge = settings.get("cors.max.age", DEFAULT_CORS_MAX_AGE);
        if (StringUtils.isBlank((String)corsAllowOrigin)) {
            return;
        }
        this.log.debug("CORS origin: {}", (Object)corsAllowOrigin);
        if (DEFAULT_CORS_ALLOW_ORIGIN.equals(corsAllowOrigin)) {
            corsOriginPattern = Pattern.compile(".*");
            return;
        }
        try {
            corsOriginPattern = Pattern.compile(corsAllowOrigin);
        }
        catch (PatternSyntaxException e) {
            this.log.error("CORS origin pattern is invalid", (Throwable)e);
            corsAllowOrigin = null;
        }
    }

    public void destroy() {
    }

    private boolean isCrossOrigin(String origin, String host) {
        return !StringUtils.isBlank((String)origin) && !origin.endsWith("//" + host);
    }

    private boolean isOriginAllowed(String origin) {
        return DEFAULT_CORS_ALLOW_ORIGIN.equals(corsAllowOrigin) || corsOriginPattern.matcher(origin).matches();
    }

    private boolean isPreflight(HttpServletRequest req) {
        return req.getMethod().equals("OPTIONS") && !StringUtils.isBlank((String)req.getHeader("Access-Control-Request-Method"));
    }

    private boolean isTextPlain(HttpServletRequest req) {
        return "text/plain;json".equals(req.getContentType());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String origin = req.getHeader("Origin");
        String host = req.getHeader("Host");
        if (corsOriginPattern == null || !this.isCrossOrigin(origin, host)) {
            chain.doFilter(request, response);
            return;
        }
        if (!this.isOriginAllowed(origin)) {
            res.setStatus(403);
            return;
        }
        res.addHeader("Access-Control-Allow-Origin", origin);
        res.addHeader("Access-Control-Allow-Credentials", corsAllowCredentials);
        if (this.isPreflight(req)) {
            res.addHeader("Access-Control-Allow-Methods", corsAllowMethods);
            res.addHeader("Access-Control-Allow-Headers", corsAllowHeaders);
            res.addHeader("Access-Control-Max-Age", corsMaxAge);
            res.setStatus(200);
            return;
        }
        if (!StringUtils.isBlank((String)corsExposeHeaders)) {
            res.addHeader("Access-Control-Expose-Headers", corsExposeHeaders);
        }
        Object wrapper = this.isTextPlain(req) ? new JsonRequest(req) : req;
        chain.doFilter((ServletRequest)wrapper, response);
    }

    private static class JsonRequest
    extends HttpServletRequestWrapper {
        public JsonRequest(HttpServletRequest request) {
            super(request);
        }

        public String getContentType() {
            return CorsFilter.CONTENT_TYPE_JSON;
        }

        public String getHeader(String name) {
            return "content-type".equals(name.toLowerCase()) ? CorsFilter.CONTENT_TYPE_JSON : super.getHeader(name);
        }
    }
}

