/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.web.service;

import com.axelor.auth.AuthUtils;
import com.axelor.db.JPA;
import com.axelor.db.JpaSecurity;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.inject.Beans;
import com.axelor.meta.ActionHandler;
import com.axelor.meta.MetaStore;
import com.axelor.meta.schema.actions.Action;
import com.axelor.meta.schema.views.AbstractView;
import com.axelor.meta.schema.views.AbstractWidget;
import com.axelor.meta.schema.views.Dashboard;
import com.axelor.meta.schema.views.Field;
import com.axelor.meta.schema.views.FormInclude;
import com.axelor.meta.schema.views.FormView;
import com.axelor.meta.schema.views.GridView;
import com.axelor.meta.schema.views.Notebook;
import com.axelor.meta.schema.views.Search;
import com.axelor.meta.schema.views.SearchFilters;
import com.axelor.meta.schema.views.SimpleContainer;
import com.axelor.meta.service.MetaService;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.Request;
import com.axelor.rpc.Response;
import com.axelor.web.service.AbstractService;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.servlet.RequestScoped;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MultivaluedMap;

@RequestScoped
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/meta")
public class ViewService
extends AbstractService {
    @Inject
    private MetaService service;
    @Inject
    private JpaSecurity security;

    private Class<?> findClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @GET
    @Path(value="models")
    public Response models() {
        Response response = new Response();
        ArrayList all = Lists.newArrayList();
        for (Class cls : JPA.models()) {
            if (!this.security.isPermitted(JpaSecurity.AccessType.READ, cls, new Long[0])) continue;
            all.add(cls.getName());
        }
        Collections.sort(all);
        response.setData((Object)all);
        response.setTotal((long)all.size());
        response.setStatus(Response.STATUS_SUCCESS);
        return response;
    }

    @GET
    @Path(value="fields/{model}")
    public Response fields(@PathParam(value="model") String model) {
        Response response = new Response();
        HashMap meta = Maps.newHashMap();
        Class<?> modelClass = this.findClass(model);
        ArrayList names = Lists.newArrayList();
        if (!this.security.isPermitted(JpaSecurity.AccessType.READ, modelClass, new Long[0])) {
            response.setStatus(Response.STATUS_FAILURE);
            return response;
        }
        for (Property p : Mapper.of(modelClass).getProperties()) {
            if (p.isTransient()) continue;
            names.add(p.getName());
        }
        meta.put("model", model);
        meta.putAll(this.findFields(model, names));
        response.setData((Object)meta);
        response.setStatus(Response.STATUS_SUCCESS);
        return response;
    }

    @GET
    @Path(value="views/{model}")
    public Response views(@PathParam(value="model") String model) {
        MultivaluedMap params = this.getUriInfo().getQueryParameters(true);
        HashMap views = Maps.newHashMap();
        for (String mode : params.keySet()) {
            views.put(mode, params.getFirst((Object)mode));
        }
        return this.service.findViews(this.findClass(model), (Map)views);
    }

    private Map<String, Object> findFields(String model, List<String> names) {
        HashMap data = Maps.newHashMap();
        if (Strings.isNullOrEmpty((String)model)) {
            return data;
        }
        Class<?> modelClass = this.findClass(model);
        Mapper mapper = Mapper.of(modelClass);
        ArrayList fields = Lists.newArrayList();
        boolean massUpdate = false;
        Object bean = null;
        try {
            bean = modelClass.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String name : names) {
            Property p = this.findField(mapper, name);
            if (p == null) continue;
            Map map = p.toMap();
            map.put("name", name);
            if (p.getSelection() != null && !"".equals(p.getSelection().trim())) {
                map.put("selection", p.getSelection());
                map.put("selectionList", this.findSelection(p));
            }
            if (p.getTarget() != null) {
                map.put("perms", MetaStore.getPermissions((Class)p.getTarget()));
            }
            if (p.isMassUpdate()) {
                massUpdate = true;
            }
            if (!p.isTransient() && !p.isVirtual()) {
                Object defaultValue;
                Object obj = null;
                if (name.contains(".")) {
                    try {
                        obj = p.getEntity().newInstance();
                    }
                    catch (Exception exception) {}
                } else {
                    obj = bean;
                }
                if (obj != null && (defaultValue = p.get(obj)) != null) {
                    map.put("defaultValue", defaultValue);
                }
            }
            fields.add(map);
        }
        Map perms = MetaStore.getPermissions(modelClass);
        if (massUpdate) {
            if (perms == null) {
                perms = Maps.newHashMap();
            }
            perms.put("massUpdate", massUpdate);
        }
        data.put("perms", perms);
        data.put("fields", fields);
        return data;
    }

    private List<String> findNames(List<String> names, AbstractWidget widget) {
        List all = null;
        if (widget instanceof Notebook) {
            all = ((Notebook)widget).getPages();
        } else if (widget instanceof SimpleContainer) {
            all = ((SimpleContainer)widget).getItems();
        } else if (widget instanceof FormInclude) {
            names.addAll(this.findNames(((FormInclude)widget).getView()));
        } else if (widget instanceof Field) {
            names.add(((Field)widget).getName());
        }
        if (all == null) {
            return names;
        }
        for (AbstractWidget item : all) {
            this.findNames(names, item);
        }
        return names;
    }

    public List<String> findNames(AbstractView view) {
        ArrayList names = Lists.newArrayList();
        List items = null;
        if (view instanceof FormView) {
            items = ((FormView)view).getItems();
        }
        if (view instanceof GridView) {
            GridView grid = (GridView)view;
            items = grid.getItems();
            if ("sequence".equals(grid.getOrderBy())) {
                names.add("sequence");
            }
        }
        if (view instanceof SearchFilters) {
            items = ((SearchFilters)view).getItems();
        }
        if (items == null || items.isEmpty()) {
            return names;
        }
        for (AbstractWidget widget : items) {
            this.findNames(names, widget);
        }
        return names;
    }

    @GET
    @Path(value="view")
    public Response view(@QueryParam(value="model") String model, @QueryParam(value="name") String name, @QueryParam(value="type") String type) {
        Response response = this.service.findView(model, name, type);
        AbstractView view = (AbstractView)response.getData();
        HashMap data = Maps.newHashMap();
        data.put("view", view);
        if (view instanceof Search && ((Search)view).getSearchForm() != null) {
            String searchForm = ((Search)view).getSearchForm();
            Response searchResponse = this.service.findView(null, searchForm, "form");
            data.put("searchForm", searchResponse.getData());
        }
        if (view instanceof AbstractView) {
            data.putAll(this.findFields(model, this.findNames(view)));
        }
        response.setData((Object)data);
        response.setStatus(Response.STATUS_SUCCESS);
        return response;
    }

    @POST
    @Path(value="view")
    public Response view(Request request) {
        Map data = request.getData();
        String name = (String)data.get("name");
        String type = (String)data.get("type");
        return this.view(request.getModel(), name, type);
    }

    @POST
    @Path(value="view/fields")
    public Response viewFields(Request request) {
        Response response = new Response();
        response.setData(this.findFields(request.getModel(), request.getFields()));
        return response;
    }

    @POST
    @Path(value="view/save")
    public Response save(Request request) {
        Map data = request.getData();
        ObjectMapper om = (ObjectMapper)Beans.get(ObjectMapper.class);
        try {
            String type = (String)data.get("type");
            String json = om.writeValueAsString((Object)data);
            AbstractView view = null;
            switch (type) {
                case "dashboard": {
                    view = (AbstractView)om.readValue(json, Dashboard.class);
                }
            }
            if (view != null) {
                return this.service.saveView(view, AuthUtils.getUser());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private Property findField(Mapper mapper, String name) {
        Iterator iter = Splitter.on((String)".").split((CharSequence)name).iterator();
        Mapper current = mapper;
        Property property = current.getProperty((String)iter.next());
        while (iter.hasNext()) {
            current = Mapper.of((Class)property.getTarget());
            property = current.getProperty((String)iter.next());
        }
        return property;
    }

    private List<?> findSelection(Property property) {
        if (property.getSelection() == null) {
            return null;
        }
        return MetaStore.getSelectionList((String)property.getSelection());
    }

    @GET
    @Path(value="chart/{name}")
    public Response chart(@PathParam(value="name") String name) {
        MultivaluedMap params = this.getUriInfo().getQueryParameters(true);
        HashMap context = Maps.newHashMap();
        Request request = new Request();
        for (String key : params.keySet()) {
            List values = (List)params.get((Object)key);
            if (values.size() == 1) {
                context.put(key, values.get(0));
                continue;
            }
            context.put(key, values);
        }
        request.setData((Map)context);
        return this.service.getChart(name, request);
    }

    @POST
    @Path(value="chart/{name}")
    public Response chart(@PathParam(value="name") String name, Request request) {
        Map data = request.getData();
        if (data == null || data.get("_domainAction") == null) {
            return this.service.getChart(name, request);
        }
        ViewService.updateContext((String)data.get("_domainAction"), data);
        return this.service.getChart(name, request);
    }

    @POST
    @Path(value="custom/{name}")
    public Response dataset(@PathParam(value="name") String name, Request request) {
        return this.service.getDataSet(name, request);
    }

    static Map<String, Object> updateContext(String action, Map<String, Object> domainContext) {
        Map ctx;
        if (action == null || domainContext == null) {
            return domainContext;
        }
        Action act = MetaStore.getAction((String)action);
        String model = (String)domainContext.get("_model");
        if (act == null || model == null) {
            return domainContext;
        }
        ActionRequest actRequest = new ActionRequest();
        HashMap<String, Object> actData = new HashMap<String, Object>();
        actData.put("_model", model);
        actData.put("_domainAction", action);
        actData.put("_domainContext", domainContext);
        actRequest.setModel(model);
        actRequest.setAction(action);
        actRequest.setData(actData);
        ActionHandler actHandler = new ActionHandler(actRequest);
        Object res = act.evaluate(actHandler);
        if (res instanceof Map && (ctx = (Map)((Map)res).get("context")) != null) {
            domainContext.putAll(ctx);
        }
        return domainContext;
    }
}

