/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.web.service;

import com.axelor.auth.AuthUtils;
import com.axelor.common.ObjectUtils;
import com.axelor.common.StringUtils;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.dms.db.DMSFile;
import com.axelor.dms.db.repo.DMSFileRepository;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.repo.MetaFileRepository;
import com.axelor.rpc.Request;
import com.axelor.rpc.Resource;
import com.google.common.primitives.Longs;
import com.google.inject.servlet.RequestScoped;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.persistence.annotations.Transformation;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/dms")
@RequestScoped
public class DmsService {
    @Context
    private HttpServletRequest httpRequest;
    @Inject
    private DMSFileRepository repository;

    @GET
    @Path(value="files")
    public com.axelor.rpc.Response listFiles(@QueryParam(value="parent") Long parentId, @QueryParam(value="pattern") String pattern) {
        com.axelor.rpc.Response response = new com.axelor.rpc.Response();
        StringBuilder filter = new StringBuilder("self.parent");
        if (parentId == null || parentId <= 0L) {
            filter.append(" is null");
        } else {
            filter.append(" = :parent");
        }
        if (!StringUtils.isBlank((String)pattern)) {
            pattern = "%" + pattern + "%";
            filter.append(" AND UPPER(self.fileName) like UPPER(:pattern)");
        }
        Query query = this.repository.all().filter(filter.toString()).bind("parent", (Object)parentId).bind("pattern", (Object)pattern);
        Long count = query.count();
        List records = query.select(new String[]{"fileName", "isDirectory"}).fetch(-1, -1);
        response.setStatus(com.axelor.rpc.Response.STATUS_SUCCESS);
        response.setData((Object)records);
        response.setTotal(count.longValue());
        return response;
    }

    @GET
    @Path(value="attachments/{model}/{id}")
    public com.axelor.rpc.Response attachments(@PathParam(value="model") String model, @PathParam(value="id") Long id) {
        com.axelor.rpc.Response response = new com.axelor.rpc.Response();
        List records = this.repository.all().filter("self.relatedId = :id AND self.relatedModel = :model AND self.metaFile is not null AND self.isDirectory = false").bind("id", (Object)id).bind("model", (Object)model).select(new String[]{"fileName"}).fetch(-1, -1);
        response.setStatus(com.axelor.rpc.Response.STATUS_SUCCESS);
        response.setData((Object)records);
        response.setTotal((long)records.size());
        return response;
    }

    @PUT
    @Path(value="attachments/{model}/{id}")
    @Transformation
    public com.axelor.rpc.Response addAttachments(@PathParam(value="model") String model, @PathParam(value="id") Long id, Request request) {
        Class<?> modelClass;
        if (request == null || ObjectUtils.isEmpty((Object)request.getRecords())) {
            throw new IllegalArgumentException("No attachment records provided.");
        }
        try {
            modelClass = Class.forName(model);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("No such model found.");
        }
        Object entity = JPA.em().find(modelClass, (Object)id);
        if (!(entity instanceof Model)) {
            throw new IllegalArgumentException("No such record found.");
        }
        MetaFileRepository filesRepo = (MetaFileRepository)Beans.get(MetaFileRepository.class);
        ArrayList<MetaFile> items = new ArrayList<MetaFile>();
        for (Object item : request.getRecords()) {
            Model fileRecord = filesRepo.find(Longs.tryParse((String)((Map)item).get("id").toString()));
            if (fileRecord instanceof MetaFile) {
                items.add((MetaFile)fileRecord);
                continue;
            }
            throw new IllegalArgumentException("Invalid list of attachment records.");
        }
        MetaFiles files = (MetaFiles)Beans.get(MetaFiles.class);
        com.axelor.rpc.Response response = new com.axelor.rpc.Response();
        ArrayList<Map> records = new ArrayList<Map>();
        for (MetaFile file : items) {
            try {
                DMSFile dmsFile = files.attach(file, file.getFileName(), (Model)entity);
                records.add(Resource.toMapCompact((Object)dmsFile));
            }
            catch (IOException iOException) {}
        }
        response.setStatus(com.axelor.rpc.Response.STATUS_SUCCESS);
        response.setData(records);
        return response;
    }

    @GET
    @Path(value="offline")
    public com.axelor.rpc.Response getOfflineFiles(@QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset) {
        com.axelor.rpc.Response response = new com.axelor.rpc.Response();
        List files = this.repository.findOffline(limit, offset);
        long count = this.repository.all().filter("self.permissions[].value = 'OFFLINE' AND self.permissions[].user = :user").bind("user", (Object)AuthUtils.getUser()).count();
        ArrayList<Map> data = new ArrayList<Map>();
        for (DMSFile file : files) {
            Map json = Resource.toMap((Object)file, (String[])new String[]{"fileName"});
            MetaFile metaFile = file.getMetaFile();
            LocalDateTime lastModified = file.getUpdatedOn();
            if (metaFile != null) {
                lastModified = metaFile.getCreatedOn();
                json.put("fileSize", metaFile.getFileSize());
                json.put("fileType", metaFile.getFileType());
            }
            json.put("id", file.getId());
            json.put("updatedOn", lastModified);
            data.add(json);
        }
        response.setData(data);
        response.setOffset(offset);
        response.setTotal(count);
        response.setStatus(com.axelor.rpc.Response.STATUS_SUCCESS);
        return response;
    }

    @POST
    @Path(value="offline")
    public com.axelor.rpc.Response offline(Request request) {
        boolean unset;
        com.axelor.rpc.Response response = new com.axelor.rpc.Response();
        List ids = request.getRecords();
        if (ids == null || ids.isEmpty()) {
            response.setStatus(com.axelor.rpc.Response.STATUS_SUCCESS);
            return response;
        }
        List records = this.repository.all().filter("self.id in :ids").bind("ids", (Object)ids).fetch();
        try {
            unset = "true".equals(request.getData().get("unset").toString());
        }
        catch (Exception e) {
            unset = false;
        }
        for (DMSFile item : records) {
            this.repository.setOffline(item, unset);
        }
        response.setStatus(com.axelor.rpc.Response.STATUS_SUCCESS);
        return response;
    }

    @GET
    @Path(value="offline/{id}")
    public Response doDownload(@PathParam(value="id") long id) {
        DMSFile file = (DMSFile)this.repository.find(Long.valueOf(id));
        if (file == null || file.getMetaFile() == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        final File path = MetaFiles.getPath((MetaFile)file.getMetaFile()).toFile();
        if (!path.exists()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        StreamingOutput so = new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                try (FileInputStream input = new FileInputStream(path);){
                    DmsService.this.writeTo(output, input);
                }
            }
        };
        return this.stream(so, file.getFileName());
    }

    @POST
    @Path(value="download/batch")
    public Response onDownload(Request request) {
        List ids = request.getRecords();
        if (ids == null || ids.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        List records = this.repository.all().filter("self.id in :ids").bind("ids", (Object)ids).fetch();
        if (records.size() != ids.size()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        String batchId = UUID.randomUUID().toString();
        HashMap<String, String> data = new HashMap<String, String>();
        String batchName = "documents-" + new LocalDate().toString("yyyy-MM-dd") + ".zip";
        if (records.size() == 1) {
            batchName = ((DMSFile)records.get(0)).getFileName();
        }
        data.put("batchId", batchId);
        data.put("batchName", batchName);
        this.httpRequest.getSession().setAttribute(batchId, (Object)ids);
        return Response.ok(data).build();
    }

    @GET
    @Path(value="download/{id}")
    @Produces(value={"application/octet-stream"})
    public Response doDownload(@PathParam(value="id") String batchOrId) {
        List ids = (List)this.httpRequest.getSession().getAttribute(batchOrId);
        if (ids == null) {
            Long id = Longs.tryParse((String)batchOrId);
            List list = ids = id == null ? null : Arrays.asList(id);
        }
        if (ids == null || ids.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        final List records = this.repository.all().filter("self.id in :ids").bind("ids", (Object)ids).fetch();
        if (records.size() != ids.size()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (records.size() == 1 && ((DMSFile)records.get(0)).getMetaFile() != null) {
            MetaFile file = ((DMSFile)records.get(0)).getMetaFile();
            return this.stream(MetaFiles.getPath((MetaFile)file).toFile(), file.getFileName());
        }
        StreamingOutput so = new StreamingOutput(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(OutputStream output) throws IOException, WebApplicationException {
                try (ZipOutputStream zos = new ZipOutputStream(output);){
                    for (DMSFile file : records) {
                        DmsService.this.writeToZip(zos, file);
                    }
                }
            }
        };
        String batchName = "documents-" + new LocalDate().toString("yyyy-MM-dd") + ".zip";
        return this.stream(so, batchName);
    }

    private Map<String, File> findFiles(DMSFile file, String base) {
        LinkedHashMap<String, File> files = new LinkedHashMap<String, File>();
        if (file.getIsDirectory() == Boolean.TRUE) {
            List children = this.repository.all().filter("self.parent = ?", new Object[]{file}).fetch();
            String path = base + "/" + file.getFileName();
            files.put(path + "/", null);
            for (DMSFile child : children) {
                files.putAll(this.findFiles(child, path));
            }
            return files;
        }
        if (file.getMetaFile() != null) {
            files.put(base + "/" + file.getFileName(), MetaFiles.getPath((MetaFile)file.getMetaFile()).toFile());
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToZip(ZipOutputStream zos, DMSFile dmsFile) throws IOException {
        Map<String, File> files = this.findFiles(dmsFile, "");
        for (String entry : files.keySet()) {
            File file = files.get(entry);
            zos.putNextEntry(new ZipEntry(entry.charAt(0) == '/' ? entry.substring(1) : entry));
            if (file == null) {
                zos.closeEntry();
                continue;
            }
            FileInputStream fis = new FileInputStream(file);
            try {
                this.writeTo(zos, fis);
            }
            finally {
                fis.close();
                zos.closeEntry();
            }
        }
    }

    private void writeTo(OutputStream os, InputStream is) throws IOException {
        int read = 0;
        byte[] bytes = new byte[2048];
        while ((read = is.read(bytes)) != -1) {
            os.write(bytes, 0, read);
        }
    }

    private Response stream(Object content, String fileName) {
        return Response.ok((Object)content, (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE).header("Content-Disposition", (Object)("attachment; filename=\"" + fileName + "\"")).header("Content-Transfer-Encoding", (Object)"binary").build();
    }
}

