/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.web.service;

import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.web.AppSessionListener;
import com.axelor.web.internal.AppInfo;
import com.axelor.web.service.AbstractService;
import com.google.inject.servlet.RequestScoped;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.shiro.subject.support.DefaultSubjectContext;

@RequestScoped
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/app")
public class AboutService
extends AbstractService {
    @Context
    private HttpServletRequest request;
    @Context
    private HttpServletResponse response;

    @GET
    @Path(value="info")
    public Map<String, Object> info() {
        AppInfo info = new AppInfo();
        return info.info(this.request.getServletContext());
    }

    @GET
    @Path(value="sysinfo")
    public Properties getSystemInfo() {
        Properties info = new Properties();
        Runtime runtime = Runtime.getRuntime();
        Set<String> sessions = AppSessionListener.getActiveSessions();
        User user = AuthUtils.getUser();
        ArrayList users = new ArrayList();
        int mb = 1024;
        boolean isTechnicalStaff = user.getGroup() != null && user.getGroup().getTechnicalStaff() == Boolean.TRUE;
        for (String id : sessions) {
            HttpSession session = AppSessionListener.getSession(id);
            if (session == null || session.getAttribute(DefaultSubjectContext.PRINCIPALS_SESSION_KEY) == null || session.getAttribute(DefaultSubjectContext.AUTHENTICATED_SESSION_KEY) != Boolean.TRUE) continue;
            String login = session.getAttribute(DefaultSubjectContext.PRINCIPALS_SESSION_KEY).toString();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("user", login);
            map.put("loginTime", session.getCreationTime());
            map.put("accessTime", session.getLastAccessedTime());
            users.add(map);
        }
        info.setProperty("osName", System.getProperty("os.name"));
        info.setProperty("osArch", System.getProperty("os.arch"));
        info.setProperty("osVersion", System.getProperty("os.version"));
        info.setProperty("javaRuntime", System.getProperty("java.runtime.name"));
        info.setProperty("javaVersion", System.getProperty("java.runtime.version"));
        info.setProperty("memTotal", runtime.totalMemory() / (long)mb + " Kb");
        info.setProperty("memMax", runtime.maxMemory() / (long)mb + " Kb");
        info.setProperty("memUsed", (runtime.totalMemory() - runtime.freeMemory()) / (long)mb + " Kb");
        info.setProperty("memFree", runtime.freeMemory() / (long)mb + " Kb");
        if (isTechnicalStaff) {
            info.put("users", users);
        }
        return info;
    }
}

