/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.web;

import com.axelor.app.AppModule;
import com.axelor.app.AppSettings;
import com.axelor.app.internal.AppFilter;
import com.axelor.auth.AuthModule;
import com.axelor.db.JpaModule;
import com.axelor.meta.MetaScanner;
import com.axelor.quartz.SchedulerModule;
import com.axelor.rpc.ObjectMapperProvider;
import com.axelor.rpc.Request;
import com.axelor.rpc.RequestFilter;
import com.axelor.rpc.Response;
import com.axelor.rpc.ResponseInterceptor;
import com.axelor.web.AppSessionListener;
import com.axelor.web.servlet.CorsFilter;
import com.axelor.web.servlet.I18nServlet;
import com.axelor.web.servlet.InitServlet;
import com.axelor.web.servlet.NoCacheFilter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Module;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.persist.PersistFilter;
import com.google.inject.servlet.ServletModule;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.shiro.guice.web.GuiceShiroFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppServletModule
extends ServletModule {
    private static final String DEFAULT_PERSISTANCE_UNIT = "persistenceUnit";
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String jpaUnit;

    public AppServletModule() {
        this(DEFAULT_PERSISTANCE_UNIT);
    }

    public AppServletModule(String jpaUnit) {
        this.jpaUnit = jpaUnit;
    }

    protected List<? extends Module> getModules() {
        AppSettings settings = AppSettings.get();
        AuthModule authModule = new AuthModule(this.getServletContext()).properties(settings.getProperties());
        AppModule appModule = new AppModule();
        SchedulerModule schedulerModule = new SchedulerModule();
        return Arrays.asList(authModule, appModule, schedulerModule);
    }

    protected void afterConfigureServlets() {
        this.serve("_init", new String[0]).with(InitServlet.class);
    }

    protected void configureServlets() {
        AppSettings settings = AppSettings.get();
        StringBuilder builder = new StringBuilder("Starting application:");
        builder.append("\n  ").append("Name: ").append(settings.get("application.name"));
        builder.append("\n  ").append("Version: ").append(settings.get("application.version"));
        this.log.info(builder.toString());
        this.bind(ObjectMapper.class).toProvider(ObjectMapperProvider.class);
        this.install((Module)new JpaModule(this.jpaUnit, true, false));
        this.install((Module)new ServletModule(){

            protected void configureServlets() {
                this.filter("*", new String[0]).through(CorsFilter.class);
                this.filter("*", new String[0]).through(PersistFilter.class);
                this.filter("*", new String[0]).through(AppFilter.class);
                this.filter("*", new String[0]).through(GuiceShiroFilter.class);
            }
        });
        for (Module module : this.getModules()) {
            this.install(module);
        }
        this.filter("/js/*", NoCacheFilter.STATIC_URL_PATTERNS).through(NoCacheFilter.class);
        this.serve("/js/messages.js", new String[0]).with(I18nServlet.class);
        this.bindInterceptor(Matchers.any(), Matchers.returns((Matcher)Matchers.subclassesOf(Response.class)), new MethodInterceptor[]{new ResponseInterceptor()});
        this.bindInterceptor(Matchers.annotatedWith(Path.class), (Matcher)new AbstractMatcher<Method>(){

            public boolean matches(Method t) {
                for (Class<?> c : t.getParameterTypes()) {
                    if (!Request.class.isAssignableFrom(c)) continue;
                    return true;
                }
                return false;
            }
        }, new MethodInterceptor[]{new RequestFilter()});
        for (Class clazz : MetaScanner.findTypes().having(Path.class).having(Provider.class).any().find()) {
            this.bind(clazz);
        }
        this.getServletContext().addListener((EventListener)((Object)new AppSessionListener(settings)));
        this.afterConfigureServlets();
    }
}

