/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.web;

import com.axelor.web.AppServletModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceServletContextListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.plugins.guice.ModuleProcessor;
import org.jboss.resteasy.plugins.server.servlet.ListenerBootstrap;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class AppContextListener
extends GuiceServletContextListener {
    private ResteasyDeployment deployment;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        super.contextInitialized(servletContextEvent);
        ServletContext context = servletContextEvent.getServletContext();
        ListenerBootstrap config = new ListenerBootstrap(context);
        this.deployment = config.createDeployment();
        this.deployment.start();
        context.setAttribute(ResteasyProviderFactory.class.getName(), (Object)this.deployment.getProviderFactory());
        context.setAttribute(Dispatcher.class.getName(), (Object)this.deployment.getDispatcher());
        context.setAttribute(Registry.class.getName(), (Object)this.deployment.getRegistry());
        Registry registry = (Registry)context.getAttribute(Registry.class.getName());
        ResteasyProviderFactory providerFactory = (ResteasyProviderFactory)context.getAttribute(ResteasyProviderFactory.class.getName());
        ModuleProcessor processor = new ModuleProcessor(registry, providerFactory);
        Injector injector = (Injector)context.getAttribute(Injector.class.getName());
        processor.processInjector(injector);
        Injector parent = injector.getParent();
        while (parent != null) {
            parent = injector.getParent();
            processor.processInjector(parent);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        this.deployment.stop();
        super.contextDestroyed(servletContextEvent);
    }

    protected Injector getInjector() {
        return Guice.createInjector((Module[])new Module[]{new AppServletModule()});
    }
}

