/**
 * @version    $Id$
 * @package    JSN_Framework
 * @author     JoomlaShine Team <support@joomlashine.com>
 * @copyright  Copyright (C) 2012 JoomlaShine.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.joomlashine.com
 * Technical Support:  Feedback - http://www.joomlashine.com/contact-us/get-support.html
 */
(
    function ($) {
        var JSNIconSelector = function (params) {

        };
        JSNIconSelector.prototype = {
            GenerateSelector:function (container, actionSelector, value, packSelect) {
                var self = this;
                var resultsFilter = $("<ul/>", {"class":"jsn-items-list"});
                $("#jsn-quicksearch-icons").val("");
                $(container).find(".jsn-reset-search").hide();
                self.renderListIconSelector(resultsFilter, packSelect, actionSelector, value);
                $.fn.delayKeyup = function (callback, ms) {
                    var timer = 0;
                    var el = $(this);
                    $(this).keyup(function () {
                        clearTimeout(timer);
                        timer = setTimeout(function () {
                            callback(el)
                        }, ms);
                    });
                    return $(this);
                };
                var oldIconFilter = "";
                return $("<div/>", {"class":"jsn-iconselector"}).append(
                    $("<div/>", {"class":"jsn-fieldset-filter"}).append(
                        $("<fieldset/>").append(
                            $("<div/>", {"class":"pull-right jsn-quick-search"}).append(
                                $("<input/>", {"class":"input search-query", "type":"text","id":"jsn-quicksearch-icons", "placeholder":"Search..."}).delayKeyup(function (el) {
                                    if ($(el).val() != oldIconFilter) {
                                        oldIconFilter = $(el).val();
                                        self.filterResults($(el).val(), resultsFilter);
                                    }
                                    if($(el).val() == ""){
                                        $(el).parents(".jsn-iconselector").find(".jsn-reset-search").hide();
                                    }else{
                                        $(el).parents(".jsn-iconselector").find(".jsn-reset-search").show();
                                    }
                                }, 500)
                            ).append(
                                $("<a/>",{"href":"javascript:void(0);","title":"Clear Search","class":"jsn-reset-search"}).append($("<i/>",{"class":"icon-remove"})).click(function(){
                                    $(this).parents(".jsn-iconselector").find("#jsn-quicksearch-icons").val("");
                                    oldIconFilter = "";
                                    self.filterResults("", resultsFilter);
                                    $(this).hide();
                                })
                            )
                        )
                    )
                ).append(resultsFilter);

            },
            filterResults:function (value, resultsFilter) {
                $(resultsFilter).find("li").hide();
                if (value != "") {
                    $(resultsFilter).find("li").each(function () {
                        var textField = $(this).find("a").attr("data-value").toLowerCase();
                        if (textField.search(value.toLowerCase()) == -1) {
                            $(this).hide();
                        } else {
                            $(this).fadeIn(1200);
                        }
                    });
                } else {
                    $(resultsFilter).find("li").each(function () {
                        $(this).fadeIn(1200);
                    });
                }
            },
            renderListIconSelector:function ( container, list, actionSelector, valueDefault) {
                $(container).find("li").removeClass("active");
                $(container).html("");

                var _nonIconClass	= 'jsn-item';
                if (!valueDefault) {
                	_nonIconClass	= 'jsn-item active';
                }
                $(container).append(
                    $("<li/>", {'class': _nonIconClass}).append(
                        $("<a/>", {
                            "href": "javascript:void(0)",
                            "class": "icons-item",
                            "data-value": ''
                        }).append($("<i/>", {"class": 'icon-'})).append('None').click(function () {
                            actionSelector(this);
                        })
                    )
                );

                $.each(list, function (value, title) {
                    var classActive = {"class":"jsn-item"};
                    if (value == valueDefault) {
                        classActive = {"class":"jsn-item active"};
                    }
                    $(container).append(
                        $("<li/>", classActive).append(
                            $("<a/>", {"href":"javascript:void(0)", "class":"icons-item", "data-value":value, "title": title}).append($("<i/>", {"class":value})).click(function () {
                                actionSelector(this);
                            })
                        )
                    );
                });
            },
            IcoMoon:function () {
                return {
                    "icon-home": "home",
                    "icon-user": "user",
                    "icon-locked": "locked",
                    "icon-comments": "comments",
                    "icon-comments-2": "comments-2",
                    "icon-out": "out",
                    "icon-redo": "redo",
                    "icon-undo": "undo",
                    "icon-file-add": "file-add",
                    "icon-plus": "plus",
                    "icon-pencil": "pencil",
                    "icon-pencil-2": "pencil-2",
                    "icon-folder": "folder",
                    "icon-folder-2": "folder-2",
                    "icon-picture": "picture",
                    "icon-pictures": "pictures",
                    "icon-list-view": "list-view",
                    "icon-power-cord": "power-cord",
                    "icon-cube": "cube",
                    "icon-puzzle": "puzzle",
                    "icon-flag": "flag",
                    "icon-tools": "tools",
                    "icon-cogs": "cogs",
                    "icon-cog": "cog",
                    "icon-equalizer": "equalizer",
                    "icon-wrench": "wrench",
                    "icon-brush": "brush",
                    "icon-eye": "eye",
                    "icon-checkbox-unchecked": "checkbox-unchecked",
                    "icon-checkbox": "checkbox",
                    "icon-checkbox-partial": "checkbox-partial",
                    "icon-star": "star",
                    "icon-star-2": "star-2",
                    "icon-star-empty": "star-empty",
                    "icon-calendar": "calendar",
                    "icon-calendar-2": "calendar-2",
                    "icon-help": "help",
                    "icon-support": "support",
                    "icon-warning": "warning",
                    "icon-checkmark": "checkmark",
                    "icon-cancel": "cancel",
                    "icon-minus": "minus",
                    "icon-remove": "remove",
                    "icon-mail": "mail",
                    "icon-mail-2": "mail-2",
                    "icon-drawer": "drawer",
                    "icon-drawer-2": "drawer-2",
                    "icon-box-add": "box-add",
                    "icon-box-remove": "box-remove",
                    "icon-search": "search",
                    "icon-filter": "filter",
                    "icon-camera": "camera",
                    "icon-play": "play",
                    "icon-music": "music",
                    "icon-grid-view": "grid-view",
                    "icon-grid-view-2": "grid-view-2",
                    "icon-menu": "menu",
                    "icon-thumbs-up": "thumbs-up",
                    "icon-thumbs-down": "thumbs-down",
                    "icon-cancel-2": "cancel-2",
                    "icon-plus-2": "plus-2",
                    "icon-minus-2": "minus-2",
                    "icon-key": "key",
                    "icon-quote": "quote",
                    "icon-quote-2": "quote-2",
                    "icon-database": "database",
                    "icon-location": "location",
                    "icon-zoom-in": "zoom-in",
                    "icon-zoom-out": "zoom-out",
                    "icon-expand": "expand",
                    "icon-contract": "contract",
                    "icon-expand-2": "expand-2",
                    "icon-contract-2": "contract-2",
                    "icon-health": "health",
                    "icon-wand": "wand",
                    "icon-refresh": "refresh",
                    "icon-vcard": "vcard",
                    "icon-clock": "clock",
                    "icon-compass": "compass",
                    "icon-address": "address",
                    "icon-feed": "feed",
                    "icon-flag-2": "flag-2",
                    "icon-pin": "pin",
                    "icon-lamp": "lamp",
                    "icon-chart": "chart",
                    "icon-bars": "bars",
                    "icon-pie": "pie",
                    "icon-dashboard": "dashboard",
                    "icon-lightning": "lightning",
                    "icon-move": "move",
                    "icon-next": "next",
                    "icon-previous": "previous",
                    "icon-first": "first",
                    "icon-last": "last",
                    "icon-loop": "loop",
                    "icon-shuffle": "shuffle",
                    "icon-arrow-first": "arrow-first",
                    "icon-arrow-last": "arrow-last",
                    "icon-arrow-up": "arrow-up",
                    "icon-arrow-right": "arrow-right",
                    "icon-arrow-down": "arrow-down",
                    "icon-arrow-left": "arrow-left",
                    "icon-arrow-up-2": "arrow-up-2",
                    "icon-arrow-right-2": "arrow-right-2",
                    "icon-arrow-down-2": "arrow-down-2",
                    "icon-arrow-left-2": "arrow-left-2",
                    "icon-play-2": "play-2",
                    "icon-menu-2": "menu-2",
                    "icon-arrow-up-3": "arrow-up-3",
                    "icon-arrow-right-3": "arrow-right-3",
                    "icon-arrow-down-3": "arrow-down-3",
                    "icon-arrow-left-3": "arrow-left-3",
                    "icon-printer": "printer",
                    "icon-color-palette": "color-palette",
                    "icon-camera-2": "camera-2",
                    "icon-file": "file",
                    "icon-file-remove": "file-remove",
                    "icon-copy": "copy",
                    "icon-cart": "cart",
                    "icon-basket": "basket",
                    "icon-broadcast": "broadcast",
                    "icon-screen": "screen",
                    "icon-tablet": "tablet",
                    "icon-mobile": "mobile",
                    "icon-users": "users",
                    "icon-briefcase": "briefcase",
                    "icon-download": "download",
                    "icon-upload": "upload",
                    "icon-bookmark": "bookmark",
                    "icon-out-2": "out-2"
                }
            },
            IcoFontAwesome: function () {
                return {
                    "fa-glass": "glass",
                    "fa-music": "music",
                    "fa-search": "search",
                    "fa-envelope-o": "envelope-o",
                    "fa-heart": "heart",
                    "fa-star": "star",
                    "fa-star-o": "star-o",
                    "fa-user": "user",
                    "fa-film": "film",
                    "fa-th-large": "th-large",
                    "fa-th": "th",
                    "fa-th-list": "th-list",
                    "fa-check": "check",
                    "fa-times": "times",
                    "fa-search-plus": "search-plus",
                    "fa-search-minus": "search-minus",
                    "fa-power-off": "power-off",
                    "fa-signal": "signal",
                    "fa-cog": "cog",
                    "fa-trash-o": "trash-o",
                    "fa-home": "home",
                    "fa-file-o": "file-o",
                    "fa-clock-o": "clock-o",
                    "fa-road": "road",
                    "fa-download": "download",
                    "fa-arrow-circle-o-down": "arrow-circle-o-down",
                    "fa-arrow-circle-o-up": "arrow-circle-o-up",
                    "fa-inbox": "inbox",
                    "fa-play-circle-o": "play-circle-o",
                    "fa-repeat": "repeat",
                    "fa-refresh": "refresh",
                    "fa-list-alt": "list-alt",
                    "fa-lock": "lock",
                    "fa-flag": "flag",
                    "fa-headphones": "headphones",
                    "fa-volume-off": "volume-off",
                    "fa-volume-down": "volume-down",
                    "fa-volume-up": "volume-up",
                    "fa-qrcode": "qrcode",
                    "fa-barcode": "barcode",
                    "fa-tag": "tag",
                    "fa-tags": "tags",
                    "fa-book": "book",
                    "fa-bookmark": "bookmark",
                    "fa-print": "print",
                    "fa-camera": "camera",
                    "fa-font": "font",
                    "fa-bold": "bold",
                    "fa-italic": "italic",
                    "fa-text-height": "text-height",
                    "fa-text-width": "text-width",
                    "fa-align-left": "align-left",
                    "fa-align-center": "align-center",
                    "fa-align-right": "align-right",
                    "fa-align-justify": "align-justify",
                    "fa-list": "list",
                    "fa-outdent": "outdent",
                    "fa-indent": "indent",
                    "fa-video-camera": "video-camera",
                    "fa-picture-o": "picture-o",
                    "fa-pencil": "pencil",
                    "fa-map-marker": "map-marker",
                    "fa-adjust": "adjust",
                    "fa-tint": "tint",
                    "fa-pencil-square-o": "pencil-square-o",
                    "fa-share-square-o": "share-square-o",
                    "fa-check-square-o": "check-square-o",
                    "fa-arrows": "arrows",
                    "fa-step-backward": "step-backward",
                    "fa-fast-backward": "fast-backward",
                    "fa-backward": "backward",
                    "fa-play": "play",
                    "fa-pause": "pause",
                    "fa-stop": "stop",
                    "fa-forward": "forward",
                    "fa-fast-forward": "fast-forward",
                    "fa-step-forward": "step-forward",
                    "fa-eject": "eject",
                    "fa-chevron-left": "chevron-left",
                    "fa-chevron-right": "chevron-right",
                    "fa-plus-circle": "plus-circle",
                    "fa-minus-circle": "minus-circle",
                    "fa-times-circle": "times-circle",
                    "fa-check-circle": "check-circle",
                    "fa-question-circle": "question-circle",
                    "fa-info-circle": "info-circle",
                    "fa-crosshairs": "crosshairs",
                    "fa-times-circle-o": "times-circle-o",
                    "fa-check-circle-o": "check-circle-o",
                    "fa-ban": "ban",
                    "fa-arrow-left": "arrow-left",
                    "fa-arrow-right": "arrow-right",
                    "fa-arrow-up": "arrow-up",
                    "fa-arrow-down": "arrow-down",
                    "fa-share": "share",
                    "fa-expand": "expand",
                    "fa-compress": "compress",
                    "fa-plus": "plus",
                    "fa-minus": "minus",
                    "fa-asterisk": "asterisk",
                    "fa-exclamation-circle": "exclamation-circle",
                    "fa-gift": "gift",
                    "fa-leaf": "leaf",
                    "fa-fire": "fire",
                    "fa-eye": "eye",
                    "fa-eye-slash": "eye-slash",
                    "fa-exclamation-triangle": "exclamation-triangle",
                    "fa-plane": "plane",
                    "fa-calendar": "calendar",
                    "fa-random": "random",
                    "fa-comment": "comment",
                    "fa-magnet": "magnet",
                    "fa-chevron-up": "chevron-up",
                    "fa-chevron-down": "chevron-down",
                    "fa-retweet": "retweet",
                    "fa-shopping-cart": "shopping-cart",
                    "fa-folder": "folder",
                    "fa-folder-open": "folder-open",
                    "fa-arrows-v": "arrows-v",
                    "fa-arrows-h": "arrows-h",
                    "fa-bar-chart": "bar-chart",
                    "fa-twitter-square": "twitter-square",
                    "fa-facebook-square": "facebook-square",
                    "fa-camera-retro": "camera-retro",
                    "fa-key": "key",
                    "fa-cogs": "cogs",
                    "fa-comments": "comments",
                    "fa-thumbs-o-up": "thumbs-o-up",
                    "fa-thumbs-o-down": "thumbs-o-down",
                    "fa-star-half": "star-half",
                    "fa-heart-o": "heart-o",
                    "fa-sign-out": "sign-out",
                    "fa-linkedin-square": "linkedin-square",
                    "fa-thumb-tack": "thumb-tack",
                    "fa-external-link": "external-link",
                    "fa-sign-in": "sign-in",
                    "fa-trophy": "trophy",
                    "fa-github-square": "github-square",
                    "fa-upload": "upload",
                    "fa-lemon-o": "lemon-o",
                    "fa-phone": "phone",
                    "fa-square-o": "square-o",
                    "fa-bookmark-o": "bookmark-o",
                    "fa-phone-square": "phone-square",
                    "fa-twitter": "twitter",
                    "fa-facebook": "facebook",
                    "fa-github": "github",
                    "fa-unlock": "unlock",
                    "fa-credit-card": "credit-card",
                    "fa-rss": "rss",
                    "fa-hdd-o": "hdd-o",
                    "fa-bullhorn": "bullhorn",
                    "fa-bell": "bell",
                    "fa-certificate": "certificate",
                    "fa-hand-o-right": "hand-o-right",
                    "fa-hand-o-left": "hand-o-left",
                    "fa-hand-o-up": "hand-o-up",
                    "fa-hand-o-down": "hand-o-down",
                    "fa-arrow-circle-left": "arrow-circle-left",
                    "fa-arrow-circle-right": "arrow-circle-right",
                    "fa-arrow-circle-up": "arrow-circle-up",
                    "fa-arrow-circle-down": "arrow-circle-down",
                    "fa-globe": "globe",
                    "fa-wrench": "wrench",
                    "fa-tasks": "tasks",
                    "fa-filter": "filter",
                    "fa-briefcase": "briefcase",
                    "fa-arrows-alt": "arrows-alt",
                    "fa-users": "users",
                    "fa-link": "link",
                    "fa-cloud": "cloud",
                    "fa-flask": "flask",
                    "fa-scissors": "scissors",
                    "fa-files-o": "files-o",
                    "fa-paperclip": "paperclip",
                    "fa-floppy-o": "floppy-o",
                    "fa-square": "square",
                    "fa-bars": "bars",
                    "fa-list-ul": "list-ul",
                    "fa-list-ol": "list-ol",
                    "fa-strikethrough": "strikethrough",
                    "fa-underline": "underline",
                    "fa-table": "table",
                    "fa-magic": "magic",
                    "fa-truck": "truck",
                    "fa-pinterest": "pinterest",
                    "fa-pinterest-square": "pinterest-square",
                    "fa-google-plus-square": "google-plus-square",
                    "fa-google-plus": "google-plus",
                    "fa-money": "money",
                    "fa-caret-down": "caret-down",
                    "fa-caret-up": "caret-up",
                    "fa-caret-left": "caret-left",
                    "fa-caret-right": "caret-right",
                    "fa-columns": "columns",
                    "fa-sort": "sort",
                    "fa-sort-desc": "sort-desc",
                    "fa-sort-asc": "sort-asc",
                    "fa-envelope": "envelope",
                    "fa-linkedin": "linkedin",
                    "fa-undo": "undo",
                    "fa-gavel": "gavel",
                    "fa-tachometer": "tachometer",
                    "fa-comment-o": "comment-o",
                    "fa-comments-o": "comments-o",
                    "fa-bolt": "bolt",
                    "fa-sitemap": "sitemap",
                    "fa-umbrella": "umbrella",
                    "fa-clipboard": "clipboard",
                    "fa-lightbulb-o": "lightbulb-o",
                    "fa-exchange": "exchange",
                    "fa-cloud-download": "cloud-download",
                    "fa-cloud-upload": "cloud-upload",
                    "fa-user-md": "user-md",
                    "fa-stethoscope": "stethoscope",
                    "fa-suitcase": "suitcase",
                    "fa-bell-o": "bell-o",
                    "fa-coffee": "coffee",
                    "fa-cutlery": "cutlery",
                    "fa-file-text-o": "file-text-o",
                    "fa-building-o": "building-o",
                    "fa-hospital-o": "hospital-o",
                    "fa-ambulance": "ambulance",
                    "fa-medkit": "medkit",
                    "fa-fighter-jet": "fighter-jet",
                    "fa-beer": "beer",
                    "fa-h-square": "h-square",
                    "fa-plus-square": "plus-square",
                    "fa-angle-double-left": "angle-double-left",
                    "fa-angle-double-right": "angle-double-right",
                    "fa-angle-double-up": "angle-double-up",
                    "fa-angle-double-down": "angle-double-down",
                    "fa-angle-left": "angle-left",
                    "fa-angle-right": "angle-right",
                    "fa-angle-up": "angle-up",
                    "fa-angle-down": "angle-down",
                    "fa-desktop": "desktop",
                    "fa-laptop": "laptop",
                    "fa-tablet": "tablet",
                    "fa-mobile": "mobile",
                    "fa-circle-o": "circle-o",
                    "fa-quote-left": "quote-left",
                    "fa-quote-right": "quote-right",
                    "fa-spinner": "spinner",
                    "fa-circle": "circle",
                    "fa-reply": "reply",
                    "fa-github-alt": "github-alt",
                    "fa-folder-o": "folder-o",
                    "fa-folder-open-o": "folder-open-o",
                    "fa-smile-o": "smile-o",
                    "fa-frown-o": "frown-o",
                    "fa-meh-o": "meh-o",
                    "fa-gamepad": "gamepad",
                    "fa-keyboard-o": "keyboard-o",
                    "fa-flag-o": "flag-o",
                    "fa-flag-checkered": "flag-checkered",
                    "fa-terminal": "terminal",
                    "fa-code": "code",
                    "fa-reply-all": "reply-all",
                    "fa-star-half-o": "star-half-o",
                    "fa-location-arrow": "location-arrow",
                    "fa-crop": "crop",
                    "fa-code-fork": "code-fork",
                    "fa-chain-broken": "chain-broken",
                    "fa-question": "question",
                    "fa-info": "info",
                    "fa-exclamation": "exclamation",
                    "fa-superscript": "superscript",
                    "fa-subscript": "subscript",
                    "fa-eraser": "eraser",
                    "fa-puzzle-piece": "puzzle-piece",
                    "fa-microphone": "microphone",
                    "fa-microphone-slash": "microphone-slash",
                    "fa-shield": "shield",
                    "fa-calendar-o": "calendar-o",
                    "fa-fire-extinguisher": "fire-extinguisher",
                    "fa-rocket": "rocket",
                    "fa-maxcdn": "maxcdn",
                    "fa-chevron-circle-left": "chevron-circle-left",
                    "fa-chevron-circle-right": "chevron-circle-right",
                    "fa-chevron-circle-up": "chevron-circle-up",
                    "fa-chevron-circle-down": "chevron-circle-down",
                    "fa-html5": "html5",
                    "fa-css3": "css3",
                    "fa-anchor": "anchor",
                    "fa-unlock-alt": "unlock-alt",
                    "fa-bullseye": "bullseye",
                    "fa-ellipsis-h": "ellipsis-h",
                    "fa-ellipsis-v": "ellipsis-v",
                    "fa-rss-square": "rss-square",
                    "fa-play-circle": "play-circle",
                    "fa-ticket": "ticket",
                    "fa-minus-square": "minus-square",
                    "fa-minus-square-o": "minus-square-o",
                    "fa-level-up": "level-up",
                    "fa-level-down": "level-down",
                    "fa-check-square": "check-square",
                    "fa-pencil-square": "pencil-square",
                    "fa-external-link-square": "external-link-square",
                    "fa-share-square": "share-square",
                    "fa-compass": "compass",
                    "fa-caret-square-o-down": "caret-square-o-down",
                    "fa-caret-square-o-up": "caret-square-o-up",
                    "fa-caret-square-o-right": "caret-square-o-right",
                    "fa-eur": "eur",
                    "fa-gbp": "gbp",
                    "fa-usd": "usd",
                    "fa-inr": "inr",
                    "fa-jpy": "jpy",
                    "fa-rub": "rub",
                    "fa-krw": "krw",
                    "fa-btc": "btc",
                    "fa-file": "file",
                    "fa-file-text": "file-text",
                    "fa-sort-alpha-asc": "sort-alpha-asc",
                    "fa-sort-alpha-desc": "sort-alpha-desc",
                    "fa-sort-amount-asc": "sort-amount-asc",
                    "fa-sort-amount-desc": "sort-amount-desc",
                    "fa-sort-numeric-asc": "sort-numeric-asc",
                    "fa-sort-numeric-desc": "sort-numeric-desc",
                    "fa-thumbs-up": "thumbs-up",
                    "fa-thumbs-down": "thumbs-down",
                    "fa-youtube-square": "youtube-square",
                    "fa-youtube": "youtube",
                    "fa-xing": "xing",
                    "fa-xing-square": "xing-square",
                    "fa-youtube-play": "youtube-play",
                    "fa-dropbox": "dropbox",
                    "fa-stack-overflow": "stack-overflow",
                    "fa-instagram": "instagram",
                    "fa-flickr": "flickr",
                    "fa-adn": "adn",
                    "fa-bitbucket": "bitbucket",
                    "fa-bitbucket-square": "bitbucket-square",
                    "fa-tumblr": "tumblr",
                    "fa-tumblr-square": "tumblr-square",
                    "fa-long-arrow-down": "long-arrow-down",
                    "fa-long-arrow-up": "long-arrow-up",
                    "fa-long-arrow-left": "long-arrow-left",
                    "fa-long-arrow-right": "long-arrow-right",
                    "fa-apple": "apple",
                    "fa-windows": "windows",
                    "fa-android": "android",
                    "fa-linux": "linux",
                    "fa-dribbble": "dribbble",
                    "fa-skype": "skype",
                    "fa-foursquare": "foursquare",
                    "fa-trello": "trello",
                    "fa-female": "female",
                    "fa-male": "male",
                    "fa-gratipay": "gratipay",
                    "fa-sun-o": "sun-o",
                    "fa-moon-o": "moon-o",
                    "fa-archive": "archive",
                    "fa-bug": "bug",
                    "fa-vk": "vk",
                    "fa-weibo": "weibo",
                    "fa-renren": "renren",
                    "fa-pagelines": "pagelines",
                    "fa-stack-exchange": "stack-exchange",
                    "fa-arrow-circle-o-right": "arrow-circle-o-right",
                    "fa-arrow-circle-o-left": "arrow-circle-o-left",
                    "fa-caret-square-o-left": "caret-square-o-left",
                    "fa-dot-circle-o": "dot-circle-o",
                    "fa-wheelchair": "wheelchair",
                    "fa-vimeo-square": "vimeo-square",
                    "fa-try": "try",
                    "fa-plus-square-o": "plus-square-o",
                    "fa-space-shuttle": "space-shuttle",
                    "fa-slack": "slack",
                    "fa-envelope-square": "envelope-square",
                    "fa-wordpress": "wordpress",
                    "fa-openid": "openid",
                    "fa-university": "university",
                    "fa-graduation-cap": "graduation-cap",
                    "fa-yahoo": "yahoo",
                    "fa-google": "google",
                    "fa-reddit": "reddit",
                    "fa-reddit-square": "reddit-square",
                    "fa-stumbleupon-circle": "stumbleupon-circle",
                    "fa-stumbleupon": "stumbleupon",
                    "fa-delicious": "delicious",
                    "fa-digg": "digg",
                    "fa-pied-piper": "pied-piper",
                    "fa-pied-piper-alt": "pied-piper-alt",
                    "fa-drupal": "drupal",
                    "fa-joomla": "joomla",
                    "fa-language": "language",
                    "fa-fax": "fax",
                    "fa-building": "building",
                    "fa-child": "child",
                    "fa-paw": "paw",
                    "fa-spoon": "spoon",
                    "fa-cube": "cube",
                    "fa-cubes": "cubes",
                    "fa-behance": "behance",
                    "fa-behance-square": "behance-square",
                    "fa-steam": "steam",
                    "fa-steam-square": "steam-square",
                    "fa-recycle": "recycle",
                    "fa-car": "car",
                    "fa-taxi": "taxi",
                    "fa-tree": "tree",
                    "fa-spotify": "spotify",
                    "fa-deviantart": "deviantart",
                    "fa-soundcloud": "soundcloud",
                    "fa-database": "database",
                    "fa-file-pdf-o": "file-pdf-o",
                    "fa-file-word-o": "file-word-o",
                    "fa-file-excel-o": "file-excel-o",
                    "fa-file-powerpoint-o": "file-powerpoint-o",
                    "fa-file-image-o": "file-image-o",
                    "fa-file-archive-o": "file-archive-o",
                    "fa-file-audio-o": "file-audio-o",
                    "fa-file-video-o": "file-video-o",
                    "fa-file-code-o": "file-code-o",
                    "fa-vine": "vine",
                    "fa-codepen": "codepen",
                    "fa-jsfiddle": "jsfiddle",
                    "fa-life-ring": "life-ring",
                    "fa-circle-o-notch": "circle-o-notch",
                    "fa-rebel": "rebel",
                    "fa-empire": "empire",
                    "fa-git-square": "git-square",
                    "fa-git": "git",
                    "fa-hacker-news": "hacker-news",
                    "fa-tencent-weibo": "tencent-weibo",
                    "fa-qq": "qq",
                    "fa-weixin": "weixin",
                    "fa-paper-plane": "paper-plane",
                    "fa-paper-plane-o": "paper-plane-o",
                    "fa-history": "history",
                    "fa-circle-thin": "circle-thin",
                    "fa-header": "header",
                    "fa-paragraph": "paragraph",
                    "fa-sliders": "sliders",
                    "fa-share-alt": "share-alt",
                    "fa-share-alt-square": "share-alt-square",
                    "fa-bomb": "bomb",
                    "fa-futbol-o": "futbol-o",
                    "fa-tty": "tty",
                    "fa-binoculars": "binoculars",
                    "fa-plug": "plug",
                    "fa-slideshare": "slideshare",
                    "fa-twitch": "twitch",
                    "fa-yelp": "yelp",
                    "fa-newspaper-o": "newspaper-o",
                    "fa-wifi": "wifi",
                    "fa-calculator": "calculator",
                    "fa-paypal": "paypal",
                    "fa-google-wallet": "google-wallet",
                    "fa-cc-visa": "cc-visa",
                    "fa-cc-mastercard": "cc-mastercard",
                    "fa-cc-discover": "cc-discover",
                    "fa-cc-amex": "cc-amex",
                    "fa-cc-paypal": "cc-paypal",
                    "fa-cc-stripe": "cc-stripe",
                    "fa-bell-slash": "bell-slash",
                    "fa-bell-slash-o": "bell-slash-o",
                    "fa-trash": "trash",
                    "fa-copyright": "copyright",
                    "fa-at": "at",
                    "fa-eyedropper": "eyedropper",
                    "fa-paint-brush": "paint-brush",
                    "fa-birthday-cake": "birthday-cake",
                    "fa-area-chart": "area-chart",
                    "fa-pie-chart": "pie-chart",
                    "fa-line-chart": "line-chart",
                    "fa-lastfm": "lastfm",
                    "fa-lastfm-square": "lastfm-square",
                    "fa-toggle-off": "toggle-off",
                    "fa-toggle-on": "toggle-on",
                    "fa-bicycle": "bicycle",
                    "fa-bus": "bus",
                    "fa-ioxhost": "ioxhost",
                    "fa-angellist": "angellist",
                    "fa-cc": "cc",
                    "fa-ils": "ils",
                    "fa-meanpath": "meanpath",
                    "fa-buysellads": "buysellads",
                    "fa-connectdevelop": "connectdevelop",
                    "fa-dashcube": "dashcube",
                    "fa-forumbee": "forumbee",
                    "fa-leanpub": "leanpub",
                    "fa-sellsy": "sellsy",
                    "fa-shirtsinbulk": "shirtsinbulk",
                    "fa-simplybuilt": "simplybuilt",
                    "fa-skyatlas": "skyatlas",
                    "fa-cart-plus": "cart-plus",
                    "fa-cart-arrow-down": "cart-arrow-down",
                    "fa-diamond": "diamond",
                    "fa-ship": "ship",
                    "fa-user-secret": "user-secret",
                    "fa-motorcycle": "motorcycle",
                    "fa-street-view": "street-view",
                    "fa-heartbeat": "heartbeat",
                    "fa-venus": "venus",
                    "fa-mars": "mars",
                    "fa-mercury": "mercury",
                    "fa-transgender": "transgender",
                    "fa-transgender-alt": "transgender-alt",
                    "fa-venus-double": "venus-double",
                    "fa-mars-double": "mars-double",
                    "fa-venus-mars": "venus-mars",
                    "fa-mars-stroke": "mars-stroke",
                    "fa-mars-stroke-v": "mars-stroke-v",
                    "fa-mars-stroke-h": "mars-stroke-h",
                    "fa-neuter": "neuter",
                    "fa-genderless": "genderless",
                    "fa-facebook-official": "facebook-official",
                    "fa-pinterest-p": "pinterest-p",
                    "fa-whatsapp": "whatsapp",
                    "fa-server": "server",
                    "fa-user-plus": "user-plus",
                    "fa-user-times": "user-times",
                    "fa-bed": "bed",
                    "fa-viacoin": "viacoin",
                    "fa-train": "train",
                    "fa-subway": "subway",
                    "fa-medium": "medium",
                    "fa-y-combinator": "y-combinator",
                    "fa-optin-monster": "optin-monster",
                    "fa-opencart": "opencart",
                    "fa-expeditedssl": "expeditedssl",
                    "fa-battery-full": "battery-full",
                    "fa-battery-three-quarters": "battery-three-quarters",
                    "fa-battery-half": "battery-half",
                    "fa-battery-quarter": "battery-quarter",
                    "fa-battery-empty": "battery-empty",
                    "fa-mouse-pointer": "mouse-pointer",
                    "fa-i-cursor": "i-cursor",
                    "fa-object-group": "object-group",
                    "fa-object-ungroup": "object-ungroup",
                    "fa-sticky-note": "sticky-note",
                    "fa-sticky-note-o": "sticky-note-o",
                    "fa-cc-jcb": "cc-jcb",
                    "fa-cc-diners-club": "cc-diners-club",
                    "fa-clone": "clone",
                    "fa-balance-scale": "balance-scale",
                    "fa-hourglass-o": "hourglass-o",
                    "fa-hourglass-start": "hourglass-start",
                    "fa-hourglass-half": "hourglass-half",
                    "fa-hourglass-end": "hourglass-end",
                    "fa-hourglass": "hourglass",
                    "fa-hand-rock-o": "hand-rock-o",
                    "fa-hand-paper-o": "hand-paper-o",
                    "fa-hand-scissors-o": "hand-scissors-o",
                    "fa-hand-lizard-o": "hand-lizard-o",
                    "fa-hand-spock-o": "hand-spock-o",
                    "fa-hand-pointer-o": "hand-pointer-o",
                    "fa-hand-peace-o": "hand-peace-o",
                    "fa-trademark": "trademark",
                    "fa-registered": "registered",
                    "fa-creative-commons": "creative-commons",
                    "fa-gg": "gg",
                    "fa-gg-circle": "gg-circle",
                    "fa-tripadvisor": "tripadvisor",
                    "fa-odnoklassniki": "odnoklassniki",
                    "fa-odnoklassniki-square": "odnoklassniki-square",
                    "fa-get-pocket": "get-pocket",
                    "fa-wikipedia-w": "wikipedia-w",
                    "fa-safari": "safari",
                    "fa-chrome": "chrome",
                    "fa-firefox": "firefox",
                    "fa-opera": "opera",
                    "fa-internet-explorer": "internet-explorer",
                    "fa-television": "television",
                    "fa-contao": "contao",
                    "fa-500px": "500px",
                    "fa-amazon": "amazon",
                    "fa-calendar-plus-o": "calendar-plus-o",
                    "fa-calendar-minus-o": "calendar-minus-o",
                    "fa-calendar-times-o": "calendar-times-o",
                    "fa-calendar-check-o": "calendar-check-o",
                    "fa-industry": "industry",
                    "fa-map-pin": "map-pin",
                    "fa-map-signs": "map-signs",
                    "fa-map-o": "map-o",
                    "fa-map": "map",
                    "fa-commenting": "commenting",
                    "fa-commenting-o": "commenting-o",
                    "fa-houzz": "houzz",
                    "fa-vimeo": "vimeo",
                    "fa-black-tie": "black-tie",
                    "fa-fonticons": "fonticons"
                }
            }
        };

        $(document).ready(function() {
            var iconSelector = $("#icon_selector");
            if(iconSelector.length){
                var inputIcon = iconSelector.find(":hidden").first();
                var jsnIconSelector = new JSNIconSelector();

                var actionSelector = $.proxy(function (_this) {
                    $(_this).parents(".jsn-items-list").find(".active").removeClass("active");
                    $(_this).parent().addClass("active");
                    inputIcon.val($(_this).attr("data-value"));
                    inputIcon.trigger('change');
                }, this);
                var selectIconPack = $("<select/>", {'class': 'jsn-select-icon-pack'})
                    .append($("<option/>", {'value': 'IcoFontAwesome'}).append("Font Awesome"))
                    .append($("<option/>", {'value': 'IcoMoon'}).append("IcoMoon"))
                    .on("change", function () {
                        iconSelector.find('.jsn-iconselector').remove();
                        if ($(this).val() == "IcoFontAwesome") {
                            iconSelector.append(jsnIconSelector.GenerateSelector(iconSelector, actionSelector, inputIcon.val(), jsnIconSelector.IcoFontAwesome()));
                        } else {
                            iconSelector.append(jsnIconSelector.GenerateSelector(iconSelector, actionSelector, inputIcon.val(), jsnIconSelector.IcoMoon()));
                        }
                    });
                var iconSelect = inputIcon.val();
                var packSelect = jsnIconSelector.IcoFontAwesome();
                if (iconSelect.indexOf("icon-") == 0) {
                    selectIconPack.val("IcoMoon");
                    packSelect = jsnIconSelector.IcoMoon();
                }
                iconSelector.append(selectIconPack);
                iconSelector.append(jsnIconSelector.GenerateSelector(iconSelector, actionSelector, iconSelect, packSelect));

                // focus selected icon
                $("[data-value='" + inputIcon.val() + "']").focus()
            }
        })
    })(jQuery);